; Copyright (c) 1998-2011 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		AX_HISTOGRAM
;
;LAST CHANGED: ----------------------------------- 	08-Dec-11
;
; PURPOSE:
;	This function generates the histogram of an image
;
; CATEGORY:
;	Utility
;
; CALLING SEQUENCE:
;	Result = AX_HISTOGRAM(IMAGE, N_BINS=N_BINS)
;
; INPUTS:
;	IMAGE	2-d array
;
; KEYWORDS:
;	N_BINS	number of bins
;
; COMMON BLOCKS:
;    none
;
; MODIFICATION HISTORY:
; (27-Dec-07 aph) isolated from axis_c and AXIS standard header added
; (29-Dec-07 aph) array sizing error corrected (check: test\data\17seps.ncb, 3-fit)
; (08-Dec-11 aph) remove second 'hist' label
;-

FUNCTION ax_histogram, img, n_bins=n_bins
on_error,2

if not keyword_set(n_bins) then n_bins = 400
xt = findgen(n_bins) & xmn = min(img, max=xmx)
xt = xmn + xt*(xmx-xmn)/n_bins
dtz = histogram(double(img), binsize = double((xmx-xmn)/n_bins), /nan)
t = size(dtz)  & dtzn = lonarr(n_bins)	; KLUGE to get around corrupted descriptor problem
; transfer also gets around cases where the binsize math puts in one extrea point
for i = 0, n_bins-1 do dtzn(i) = dtz(i)
hist = fltarr(2, n_bins)
hist(0,*)=xt
hist(1,*)= dtzn
RETURN, hist
END
