; Copyright (c) 1998-2025 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		COREX_DATABASE_INDEX
;
;LAST CHANGED: -----------------------------------  29-Sep-2025 (aph) [simplified from print_is_database)
;
; PURPOSE:
;	This  is a wrapper to feed filenames read from a file to AX_ISEELS_DISPLAY
; executes AX_ISEELS_DISPLAY for each iseels database file to generate a line in a csv file
; and returns a csv file which is in format used in the Borealis (McMaster Dataverse) database (set up in 2025)

; CATEGORY:
;	stand alone
;
; CALLING SEQUENCE:
;	COREX_DATABASE_INDEX
;
; REQUIRED INPUTS: none.
;
; KEYWORDS: file

; OUTPUT:  a *.csv file (excel ready)
;
; COMMON BLOCKS: none
;;
; SIDE EFFECTS:
;	A window is created/destroyed.
;
; MODIFICATION HISTORY:
; (27-Oct-16 aph) first written
; (18-Nov-16 aph) restructured to get rid of all-files-display-at-start (DID NOT WORK)
; (18-Dec-16 aph) adapt to run from aXis2000
; (01-May-25 aph) adapt to return a string array of meta data for corex index use
; (10-May-25 aph) add "add_html keyword so the filename is set up to open the named file whrn clicked
;				   see ax_iseels_display.pro  for the html code  [ href="data/a1-0cckk.os">a1-0cckk.os</a" ]
; (07-Aug-25 aph) set up to display multile files in succession for checking content
; (07-Sep-25 aph) generate corex-index improved
; (29-Sep-25 aph) evolved from PRINT_IS_DATABASE function
; -

FUNCTION COREX_DATABASE_INDEX, file = file

;  default location of corex data files is D:\aph-website\corex\data
if not keyword_set(file) then begin
;	cd, "D:\corex-flat\data"
	list = dialog_pickfile(title='Select ISEELS database files', /read, /multiple_files)
endif else list = file

n_files = n_elements(list)
index_list = strarr(n_files)

;  -------------------  set switch for optional ADD html code to the filename
;	<a href="data/a1-0cckk.os">a1-0cckk.os</a>  puts a link on the file name
;-----------  ask user if they want to include the html code to click on filenames
	t = dialog_message('Add html code for clickable filenames ?', /question, dialog_parent=aXis_ID)
	if t EQ 'Yes' then add_html=1


;	set plot keyword to 0, as only want to use this code to generate a *.csv index file
; plot = 0
; ------------------  process each file in turn
for i = 0, n_files-1 do begin
	t = ax_name(list(i))
;	-------------
	if keyword_set(add_html) then $
		 next = ax_iseels_display(file = list(i), /flat_table, plot=0, add_html=1)	$	;next  is the string for entry i
		else next = ax_iseels_display(file = list(i), /flat_table,  plot=0)

;  this returns a string like the following
;       Hexaphenyldisilane, (C6H5)6Si2, C36H30Si2, C1s, a1-1cckk.os, HH13, Hitchcock (unpublished)
	index_list(i)=next
endfor

index_out=dialog_pickfile(title='write index csv file', /write, DEFAULT_EXTENSION='csv')
openw, unit,index_out, /get_lun
printf,unit, 'Name, Formula, alpha-formula, edge, filename, Ref. Code, Reference,'
for i = 0, n_files-1 do begin
	printf, unit, index_list(i)
endfor
print, 'index list written to ', index_out
close, unit

return, index_list

end