; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
;+ 
;NAME: 
;	DEGLITCH 
; 
;LAST CHANGED: ----------------------------------- 19-dec-00 
; 
;PURPOSE: 
;	This function replaces out-of-bound values with 
; a local 3-point average. Bounds are user selected by cursor. 
; 
;CATEGORY: 
;	STAND ALONE: image processing 
; 
;CALLING SEQUENCE: 
;	Result = DEGLITCH(tmp) 
; 
;CALLED FROM AXIS: 
;	->Images->Deglitch 
 
;INPUTS: 
;	A - an array (treated as 1-d vector, even if an image) 
; 
;KEYWORDS: 
;	none 
; 
;OUTPUTS: 
;	The result is an array with modified intensities. 
; 
;COMMON BLOCKS: 
;	@AXIS_COM	standard set of common blocks 
; 
;SIDE EFFECTS: 
;	A window is created if there is no window currently displayed. 
; 
;PROCEDURE: 
;	The intensities of an image are displayed as a spectrum on 
; MainImg (if in AXIS) or on the current or a generated window. 
; Two cursor clicks then identify lower and upper bounds of interest. 
; Values outside the range are replaced by local averages 
; This is an alternate to CLIP. It works nicely for localized, 
; single pixel 'glitches' but CLLP is better for extended artefacts 
; 
;EXAMPLE: 
; Create a sample nxn image, display, clip, and redisplay 
;	n = 100 &  d = dist(n) & d(n/2)=5*d(n/2) 
;	tvscl, d   ; display input 
;	b = DEGLITCH(d)	 ; deglitch 
;	tvscl, b 
; 
;MODIFICATION HISTORY: 
; (31-dec-99 aph) isolated from AXIS_C as a stand-alone 
;				  AXIS standard documentation 
; (19-dec-00 cgz) substituted ax_white_color_index with ax_plot_axes_color_index
;			substituted ax_black_color_index with ax_plot_bkgd_color_index
;- 
 
FUNCTION DEGLITCH, a 
@axis_com
on_error,2 
 
plot, a, xstyle=1, color=ax_plot_axes_color_index, background=ax_plot_bkgd_color_index 
WIDGET_CONTROL, Uprompt, BAD_ID = BadID, Set_Value = 'Deglitch: click to set lower bound' 
cursor, x1, y1, /data, /down 
WIDGET_CONTROL, Uprompt, BAD_ID = BadID, Set_Value = 'Deglitch: click to set upper bound' 
cursor, x2, y2, /data, /down 
zl=where(a LT y1, cntl) 
zh=where(a GT y2, cnth) 
if cntl GT 0 then begin 
	zl = zl>1  & zl = zl <n_elements(a)-2 
	a(zl)=(a(zl-1)+a(zl+1))*0.5 
endif 
if cnth GT 0 then begin 
	zh=zh>1    & zh = zh <n_elements(a)-2 
	a(zh)=(a(zh-1)+a(zh+1))*0.5 
endif 
print, 'Deglitched ', cntl+cnth, ' points' 
return, a 
end 
