; Copyright (c) 1998-2010 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		READ_ENERGIES.PRO
;
;LAST CHANGED: ----------------------------------- 	19-Jul-10
;
; PURPOSE:
;	This function reads a text file to extract an array of energies (in eV) and returns the array
;
; CATEGORY:
;	Utility; part of XSpecSim , spectral simulator package
;
; CALLING SEQUENCE:
;	Result = READ_ENERGIES(FILE=FILE, FILTER=FILTER)
;
; INPUTS: none
;
; KEYWORDS:
;	FILE	file name
;	FILTER	filter for extension
;
; OUTPUTS: none
;
;COMMON BLOCKS:
;	@XSpecSim_Com		X-SpecSim common block
;
;
; MODIFICATION HISTORY:
; (28-feb-07 jso) first version
; (18-Jul-10 aph) AXIS standard header added; XSpecSim_com added
;-


function read_energies, file=file, filter=filter
@XSpecSim_Com

if not keyword_set(file) then begin
	;filter='*.txt'
	file_e = pickfile2(Title='Select Energies File', /READ, FILTER=filter, /LPATH)
endif else file_e = file
if strlen(file_e(0)) eq 0 then return, s
t = ax_name(file_e)
check=findfile(file_e)
openr, iunit, file_e, /get_lun
test= ''
pos=0
while pos NE -1 do begin
	readf, iunit, test
	pos = strpos(test,'#')
endwhile
ans=fltarr(10000)
test = strtrim(test,2)
t=parsestring(test)
ans(0)=	t
j=long(1)
while not eof(iunit) do begin
	readf, iunit, test
	test = strtrim(test,2)
	t=parsestring(test)
	ans(j)=	t
	j=j+1
endwhile
ans=ans(0:j-1)

close, iunit & free_lun, iunit
return, ans
end