; Copyright (c) 1998-2014 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		SXM_STRCLEAN
;
;LAST CHANGED: ----------------------------------- 	22 Jul 2014
;
; PURPOSE:
;	This  function interconverts strings (to read) and bytearrays (to store in netCDF)
;
; CATEGORY:
;	NSLS-1 cryo-STXM (SXM) utility
;
; CALLING SEQUENCE:
;	Result = SXM_STRCLEAN(input [,to_string=to_string, to_bytearray=to_bytearray])
;
; INPUTS:
;	INPUT	parameter to convert
;
; KEYWORDS:
;	to_string - if set, convert to a string
;	to_bytearray - if set, convert to a bytearray
;
; COMMON BLOCKS:
;	sxm_common
;
; MODIFICATION HISTORY:
; (21-Dec-00 cjj) file obtained from CJJ's source
; (22-Jul-14 aph) AXIS standard header added
;-

FUNCTION Sxm_strclean, input,to_string=to_string, $
                       to_bytearray=to_bytearray
@sxm_common

input = string(input)
IF keyword_set(to_bytearray) THEN BEGIN
    output = bytarr(sxm_strlen)
    output(0:(strlen(input)-1)) = byte(input)
ENDIF ELSE IF keyword_set(to_string) THEN BEGIN
    output = strtrim(input, 2)
    IF (strlen(output) EQ 0) THEN output = ' '
ENDIF

return, output
END



