; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
;+ 
;NAME: 
;	AX_CONV 
; 
;LAST CHANGED: ----------------------------------- 31-dec-99 
; 
;PURPOSE: 
;	This function convert one or a sequence of ALS image files 
; to netCDF image file format. Optional binning for smoothing. 
; 
;CATEGORY: 
;	AXIS: stack analysis 
; 
;CALLING SEQUENCE: 
; for functions: 
;	Result = AX_CONV() 
; 
;CALLED FROM AXIS: 
;	->Stacks->convert format->ALS to netCDF->many 
 
;INPUTS: none 
; 
;KEYWORDS: none 
; 
;OUTPUTS: 
;	*.sla (input list); {filename.nc}, *.sl file written to disk 
;	result = 1 is returned regardless of action 
; 
;COMMON BLOCKS: 
;	@AXIS_COM	standard set of common blocks 
; 
;PROCEDURE: 
;	generates an input list file and bin parameter for ALS2NCDF 
; 
;EXAMPLE: 
;	Please provide a simple example here. An example from the PICKFILE 
;	documentation is shown below. Please try to include examples that 
;       do not rely on variables or data files that are not defined in 
;       the example code. Your example should execute properly if typed 
;       in at the IDL command line with no other preparation. 
; 
;	Create a PICKFILE widget that lets users select only files with 
;	the extensions 'pro' and 'dat'.  Use the 'Select File to Read' title 
;	and store the name of the selected file in the variable F.  Enter: 
; 
;		F = PICKFILE(/READ, FILTER = ['pro', 'dat']) 
; 
;MODIFICATION HISTORY: 
;(03-dec-98 aph) extracted from axis_c 
;( 7-jan-99 aph) added, bad_ID to widget_controls to allow stand-alone use 
;( 8-jun-99 aph) modify get_num call to identify group 
;( 7-jul-99 aph) FREE_LUN not just close 
;(31-dec-99 aph) AXIS standard documentation 
;- 
FUNCTION ax_conv 
 
@axis_com
@bsif_com
on_error,2 
 
  WIDGET_CONTROL, Uprompt, BAD_ID = BadID, SET_VALUE='pick first file of sequence' 
  file1=PICKFILE2(/Read, FILTER='*.im*', /LPATH, DEFPATH=defpath) 
  if strlen(file1) GT 0 THEN BEGIN 
     WIDGET_CONTROL, Uprompt, BAD_ID = BadID, SET_VALUE='pick last file of sequence' 
     file2=PICKFILE2(/Read, FILTER='*.im*', /LPATH, DEFPATH=defpath) 
	 if strlen(file2) GT 0 THEN BEGIN 
; assumes all ALS file names are 12 characters (8.3) 
; and that columns 6-8 are a sequential file number 
; ALS BL 7.0 STXM convention is YMMDD###.im% for image files 
		fileroot=strmid(file1, 0, strlen(file1)-7) 
    	fileshort=strmid(file1,strlen(file1)-12, strlen(file1)-7) 
    	first = fix(strmid(file1,strlen(file1)-7, strlen(file1)-4)) 
    	last  = fix(strmid(file2,strlen(file2)-7, strlen(file2)-4)) 
; allow any extension by picking up ext from pickfile choice (aph 14-feb-98) 
		spos=strpos(file1,'.') 
		if (spos ne -1) then ext = strmid(file1,spos+1,3)    ; take extension 
		WIDGET_CONTROL, Uprompt, BAD_ID = BadID, SET_VALUE= 'ALS->nc: name ALS-file-list file' 
    	filestore = pickfile2(/write,/lpath,filter='*.sla', DEFPATH=defpath) 
;    	print, fileroot,fileshort, first,last, ext, filestore 
     	openw,unit, filestore,/get_lun 
   		for i = first, last do begin 
      		num = strcompress(string(1000 + i)) 
      		num = strmid(num,2,4) 
      		file=fileroot + num + '.' + ext 
			printf,unit, strcompress(file) 
    	endfor 
   		close, unit & free_lun, unit 
   		WIDGET_CONTROL, Uprompt, BAD_ID = BadID, SET_VALUE= 'ALS->nc: smooth by binning?' 
		bin_num=1				; optional binning of data 
		if widget_info(/active) EQ 1 then $ 
			bin_num=get_num(Val=bin_num,PROMPT='bin *', group=axis_id) $ 
				else bin_num=get_num(Val=bin_num,PROMPT='bin *') 
	    als2ncdf,list=filestore,bin=bin_num(0) 
; write file with names for *.nc files (for Stack_analyze) 
	    WIDGET_CONTROL, Uprompt, BAD_ID = BadID, SET_VALUE='Done. File list for *.nc' 
	    filestore = pickfile2(/write,filter='*.sl', DEFPATH=defpath) 
	    openw,unit, filestore,/get_lun 
   		for i = first, last do begin 
      		num = strcompress(string(1000 + i)) 
      		num = strmid(num,2,4) 
      		file=fileroot + num + '.nc' 
			printf,unit, strcompress(file) 
    	endfor 
   		close, unit & free_lun, unit 
   	endif 
  endif 
  return, 1 
  end 
