; Copyright (c) 1998-2010 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		AX_STRMID
;
;LAST CHANGED: ----------------------------------- 	21-Feb-10
;
; PURPOSE:
;	This function returns the parts of  string between 2 user defined strings
;
; CATEGORY:
;	Utility
;
; CALLING SEQUENCE:
;	Result = AX_STRMID(STRALL, STR1, STR2)
;
; INPUTS:
; 	STRALL	string to be parsed
;	STR1	start collecting at 1 character after STR1
;	STR2	stop collecting at 1 character before STR2
;
; KEYWORDS: NONE
;
; OUTPUTS:
;	returns middle part of a string defined by other strings
;
; COMMON BLOCKS:
;	NONE
;
; MODIFICATION HISTORY:
; (21-Feb-10 aph) AXIS standard header added
;-

FUNCTION  AX_STRMID, STRALL, STR1, STR2

pos1 = strpos(strall, str1) + strlen(str1)
st = strmid(strall, pos1)
pos2 = strpos(st, str2)
s = strmid(strall,pos1, pos2)

; print, pos1, pos1+pos2
; print, s

return, s

END