; Copyright (c) 1998-2023 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_ZOOM_CURSOR
;
;LAST CHANGED: ----------------------------------- 07 Nov 2023
;
;PURPOSE:
;	This procedure zooms a sub region of the current image displayed
; by using a marquee (Box cursor) to select the zoom region.
; The zoomed region is extracted from the original data and
; placed as a new AXIS structure in buffer 0.
;
;CATEGORY:
;	AXIS: image analysis
;
;CALLING SEQUENCE:
;	AX_ZOOM_CURSOR
;
;CALLED FROM AXIS:
;	Zoom->Images->cursor - cut
;
;INPUT: none
;
;KEYWORDS: none
;
;OUTPUTS:
;	Region cut from image is placed as a new AXIS 2d structure in buffer 0.
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;PROCEDURE:
; 	Uses BX_CURSOR to define a region to zoom
; nb - BX_CURSOR is derived from IDL's BOX_CURSOR
; but the left and middle buttons have been swapped
; to make it compatible with 2-button mice
; NB this routine is written to handle spectra as well, but currently not used.
; Spectra->Truncate performs the equivalent function for spectra.
;
;MODIFICATION HISTORY:
; (28-dec-99 aph) isolated from AXIS_C
; (01-jan-00 aph) AXIS standard documentation
; (17-apr-01 aph) added E to output structure
; (21-aug-01 aph) ensured code compatible with 2d structures without E
; (28-Aug-22 aph) move tag to end of header
; (07-Nov-23 aph) use ' Zc' to indicate cursor=based zoom
;-
PRO AX_ZOOM_CURSOR
@axis_com
on_error,2

HANDLE_VALUE, Data(CurBuf), tmp
IF n_tags(tmp) EQ 0 THEN RETURN
 IF tmp.t EQ '2d' then BEGIN
	SetGraf,'MainImg'     ; restore image (x,y) scaling parameters
	text = string(format='("Left - resize",/,"Middle - move",/,"Right - done",A)','')
	WIDGET_CONTROL, Uprompt, SET_VALUE= text
	BX_CURSOR, xl, yl, w, h
;Convert to data coordinates
	ll=CONVERT_COORD(xl, yl, /DEVICE, /TO_DATA)
	ur=CONVERT_COORD(xl + w, yl + h, /DEVICE, /TO_DATA)
;Set the zoom range
	!x.range(0) = ll(0) & !x.range(1) = ur(0)
	!y.range(0) = ll(1) & !y.range(1) = ur(1)
	Ilo = DIndex(ll(0),ll(1),tmp)
	Ihi = DIndex(ur(0),ur(1),tmp)
; cut out the zoomed data from tmp
   	xn = tmp.x(Ilo(0):Ihi(0))	; cut out the zoomed data from tmp
   	CASE tmp.t OF
   	 '1d' : BEGIN
	   	 dzoom = tmp.d(Ilo(1):Ihi(1))
	   	 tmp = {t:'1d', x:xn,d:dzoom, xl:tmp.xl, dn: tmp.dn, dl:tmp.dl + '  Zc' }
	  END
	 '2d' : BEGIN
		 yn = tmp.y(Ilo(1):Ihi(1))
	   	 dzoom = tmp.d(Ilo(0):Ihi(0),Ilo(1):Ihi(1))
	   	 t = where(tag_names(tmp) EQ 'E')
	   	 if t(0) EQ -1 then E = 0. else E=tmp.e
	   	 tmp = create_struct('t','2d','x',xn,'y',yn,'d',dzoom, $
		'xl',tmp.xl,'yl',tmp.yl,'dl',tmp.dl + ' Zc', 'E',E)
	  END
	 ENDCASE
 CurBuf = 0
 HANDLE_VALUE, Data(CurBuf), tmp, /set
 Label(CurBuf) = tmp.dl
 PlotBuf,CurBuf
 WIDGET_CONTROL, Uprompt, SET_VALUE= ' '
endif else WIDGET_CONTROL, Uprompt, SET_VALUE='Zoom.images : not for spectra'
END
