; Copyright (c) 1998-2010 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AXIS_PEEM_UPDATE
;
;LAST CHANGED: ----------------------------------- 11-Jan-10
;
;PURPOSE:
;	This set of procedures are the event processing for the AXIS_PEEM peem processing widget.
;
;CATEGORY:
;	AXIS: utility
;
;ROUTINES
; AXIS_Opts_Update - loads current default values into AXIS_OPTIONS widget
; BUT_Update, Event - takes info from the AXIS_OPTIONS widget
;                     and writes the ini file
;	BUT_Cancel	- cancel
;	BUT_WIN		BUT_X		BUT_OpSys_Other	TXT_Set_Op_Sys - op. system
;	BUT_PS	BUT_PCL		BUT_Print_Other		TXT_Set_Print_device - printer
;	BUT_Mac	BUT_ALS	BUT_NSLS	BUT_Location_Other	TXT_Set_Location - location
;	BUT_Size_050	BUT_Size_075	BUT_Size_100	BUT_Size_125
;	BUT_Size_150	- size of AXIS
;	Zero_buts	- sets exclusive buttons to zero on starting widget
;	Load_def_Win	- loads default parameters for Windows systems
;	Load_Def_X		- loads default parameters for unix systems
;	BUT_INI_Browse	BUT_SOURCE_Browse	BUT_DATA_Browse	BUT_Print_Browse
;	browse for file names
;	axis_options_eventcb - auto loading stub
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;PROCEDURE:
; 	works with AXIS_OPTIONS.PRO Widget to establish AXIS defaults
;
; RESTRICTIONS
; does not work !!! - from cgz changes to axis Nov00 to Jan01
;
;MODIFICATION HISTORY:
; (aph 03-jun-01) first written - adapted from axis_options
; (aph 11-Jan-10) changed axis_ini_save call from procedure to a function (ITT support bug fix)
;                 removed all routines except AXIS_PEEM_update and
;-
;

; ****************************************************************

pro AXIS_PEEM_Update, wWidget
@axis_com

	PRINT, 'Loading current values'
   	id = widget_info(wWidget, FIND_BY_UNAME = 'TXT_Ini_File')
   	WIDGET_CONTROL,id, Set_value = ini_file
   	print, 'ini_file = ', ini_file
   	id = widget_info(wWidget, FIND_BY_UNAME = 'TXT_Source_Path')
   	WIDGET_CONTROL,id, Set_value = CodePath
   	print, 'CodePath = ', CodePath
   	id = widget_info(wWidget, FIND_BY_UNAME = 'TXT_Data_Path')
   	WIDGET_CONTROL,id, Set_value = DefPath
   	print, 'DefPath = ', DefPath
  	id = widget_info(wWidget, FIND_BY_UNAME = 'TXT_Color_Table')
   	WIDGET_CONTROL,id, Set_value = strcompress(string(ColTbl))
   	print, 'Color table = ', strcompress(string(ColTbl))
  	id = widget_info(wWidget, FIND_BY_UNAME = 'TXT_Font')
   	WIDGET_CONTROL,id, Set_value = BufLblFont
   	print, 'BufLblFont = ', BufLblFont
  	id = widget_info(wWidget, FIND_BY_UNAME = 'TXT_Print_command')
   	WIDGET_CONTROL,id, Set_value = Pr_command
   	print, 'Print command = ', Pr_command
  	id = widget_info(wWidget, FIND_BY_UNAME = 'TXT_Help_cmd')
   	WIDGET_CONTROL,id, Set_value = Help_cmd
   	print, 'Help command = ', Help_cmd
   	id = widget_info(wWidget, FIND_BY_UNAME = 'TXT_Web_cmd')
   	WIDGET_CONTROL,id, Set_value = Net_command
   	print, 'Net browser command = ', Net_command

; ---------- exclusive button boxes
; ------- Op_Sys --------
CASE gr_dev OF
'WIN': BEGIN
	id = widget_info(wWidget, FIND_BY_UNAME = 'BUT_WIN')
	WIDGET_CONTROL,id, Set_Button = 1
END
'X': BEGIN
	id = widget_info(wWidget, FIND_BY_UNAME = 'BUT_X')
	WIDGET_CONTROL,id, Set_Button = 1
END
ELSE: BEGIN
	id = widget_info(wWidget, FIND_BY_UNAME = 'BUT_OpSys_Other')
	WIDGET_CONTROL,id, Set_Button = 1
   	id = widget_info(wWidget, FIND_BY_UNAME = 'TXT_Set_Op_Sys')
   	WIDGET_CONTROL,id, Sensitive=1, Set_Value = gr_dev
ENDELSE
ENDCASE

; ------- Print_Device  --------
CASE Print_dev OF
'PS': BEGIN
   id = widget_info(wWidget, FIND_BY_UNAME = 'BUT_PS')
   WIDGET_CONTROL,id, Set_Button = 1
END
'PCL': BEGIN
   id = widget_info(wWidget, FIND_BY_UNAME = 'BUT_PCL')
   WIDGET_CONTROL,id, Set_Button = 1
END
ELSE: BEGIN
	id = widget_info(wWidget, FIND_BY_UNAME = 'BUT_Print_Other')
	WIDGET_CONTROL,id, Set_Button = 1
   	id = widget_info(wWidget, FIND_BY_UNAME = 'TXT_Set_Print_Device')
   	WIDGET_CONTROL,id, Sensitive=1, Set_Value = Print_dev
ENDELSE
ENDCASE

; ------- Location --------
CASE location OF
'mac': BEGIN
   id = widget_info(wWidget, FIND_BY_UNAME = 'BUT_Mac')
   WIDGET_CONTROL,id, Set_Button = 1
END
'ALS': BEGIN
   id = widget_info(wWidget, FIND_BY_UNAME = 'BUT_ALS')
   WIDGET_CONTROL,id, Set_Button = 1
END
'NSLS': BEGIN
   id = widget_info(wWidget, FIND_BY_UNAME = 'BUT_NSLS')
   WIDGET_CONTROL,id, Set_Button = 1
END
ELSE: BEGIN
	id = widget_info(wWidget, FIND_BY_UNAME = 'BUT_Location_Other')
	WIDGET_CONTROL,id, Set_Button = 1
   	id = widget_info(wWidget, FIND_BY_UNAME = 'TXT_Set_Location')
   	WIDGET_CONTROL,id, Sensitive=1, Set_Value = location
ENDELSE
ENDCASE

END

