pro histo_wrap, x, min, max, nbins, bin_edges, bin_cntrs, hx

;+
;NAME:
;histo_wrap -- wrapper for histogram that returns the bin edges and centers
;
;PURPOSE: wrapper for histogram that returns the bin edges and centers
;note fixed inputs: max, min, nbins.
;
;CALLING SEQUENCE:
;	histo_wrap, x, min, max, nbins, bin_edges, bin_cntrs, hx
;
;INPUTS:
;	X, the input array
;	MIN, the min value in the histogram
;	MAX, the max value in the histogram
;	NBINS, the nr of bins in the histogram
;
;OUTPUTS
;	BIN_EDGES
;	BIN_CNTRS
;	HX, the histogram of the input array x
;-
;

dmin= double(min)
dmax= double(max)
;dx= double( x)

bin_edges= dmin+ (dmax-dmin)* (dindgen( nbins)/ ( nbins-1.))
bin_cntrs= dmin+ (dmax-dmin)* ( (dindgen( nbins)+0.5)/ ( nbins-1.))
hx = histogram( x, nbins= nbins, min=dmin, max=dmax)

return
end
