; Copyright (c) 1998-2013 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		RED_A_N.PRO
;
;LAST CHANGED: ----------------------------------- 	30-Aug-2013
;
; PURPOSE:
;	This function reads a Beamline 7 STXM image from a text file (*,img)
; 	then reads corresponding *,nrm normalization file
;	The first two lines contain image size (pixels) of (*,dat)
;
; CATEGORY:
;	data read-in.
;
; CALLING SEQUENCE:
;	result = READ_A_N, FILE, PLOT=pl, DEGLITCH=dgl, FILTER=fltr, _extra=e
;
; INPUTS:
; 	FILE	name of file
;
; KEYWORDS:
;	PLOT		if set, plot
;	DEGLITCH	if set, deglitch
;	FILTER		defines extension
;
; OUTPUTS:
;	returns BL7 STXM image (1995-2000 version)
;
; COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;
; MODIFICATION HISTORY:
; ;     adapted from READ_IMG.PRO (Stefano code  of Jan97)
;    	Eventually - replace with JDD's integrated version
; ( 7-Aug-97 aph) separate file  (aph 9-oct-97 control color locally)
; (16-oct-97 aph)  double read
; ( 4-mar-98 aph) gets photon energy, dwell and stores in SD
; ( 7-jul-99 aph) FREE_LUN as well as close !
; (15-nov-00 cgz) Replaced call of NCOLS function by explicit (SIZE(var))(1)
; (15-nov-00 cgz) Replaced call of NROWS function by explicit (SIZE(var))(2)
; (30-Aug-13 aph) AXIS standard header added
;-

function read_a_n, file, PLOT=pl, DEGLITCH=dgl, FILTER=fltr, _extra=e

@axis_com
on_error,2

if n_elements(file) eq 0 then begin  ;popup file dialog box
;   if not keyword_set(fltr) then fltr='*.img'
	fltr='*.im*'
    file=PICKFILE2(/Read, FILTER=fltr, /FIX_FILTER, /LPATH, DEFPATH=defpath)
endif

if strlen(file) GT 0 THEN BEGIN
	fileshort=strmid(file,strlen(file)-12, strlen(file))   ; assumes all ALS file names are 12 char.
; allow any extension by picking up ext from pickfile choice (aph 14-feb-98)
	spos=strpos(file,'.')
	if (spos ne -1) then begin
	   ext = strmid(file,spos+1,3)    ; take extension
	   file=strmid(file,0,spos)		; strip extension
    endif
	file=strlowcase(file)
; (aph 2-mar-98 - converted to jacobsen's readin as it does not assume SQUARE input data !)
; puts energy and dwell parameters into the nsls SCANDATA (SD) structure
openr,lun,(file+'.dat'), /get_lun
x_start = float(0)    &   x_step = float(0)
y_start = float(0)    &   y_step = float(0)
n_cols = fix(0)       &   n_rows = fix(0)
input_string = ''
readf,lun,input_string
reads,input_string,x_start,x_step,n_cols
;print, '1:  ', input_string
xoff = 1.e3*x_start  & xincr = 1.e3*x_step
readf,lun,input_string
reads,input_string,y_start,y_step,n_rows
;print, '2:  ', input_string
yoff = 1.e3*y_start  & yincr = 1.e3*y_step
readf,lun,input_string
;print, '3:  ', input_string
on_ioerror, continue
energy = 0.
reads,input_string,delay,delay,dwell,energy
continue:                ; when reading pre-Mar-98 files without photon energy
on_ioerror,null
sd.dwell_time = dwell/1000.    ; report dwell in msec
close,lun & free_lun, lun
if (energy NE 0)then begin
	print, format='("Energy (eV) = ",f7.3,". Dwell (ms) = ",f6.2)', energy, sd.dwell_time
	sd.wavelength=12398./energy    ; save photon energy as wavelength
endif
;Do not allow zero increment. If so set to 1.
	xincr=xincr + (xincr eq 0.)
	yincr=yincr + (yincr eq 0.)

	a = text_read1(file+'.'+ext)
	file_nrm = file+'.nrm'
	test=findfile(file_nrm)
	if test NE '' then begin
		b = text_read1(file+'.nrm')
	endif else begin
		fltr='*.im*'
    	file_nrm=PICKFILE2(/Read, FILTER=fltr, /FIX_FILTER, /LPATH, DEFPATH=defpath)
	 	b = text_read1(file_nrm)
	endelse
	;nc=ncols(a)
	nc=(size(a))(1)
	;nr=nrows(a)
	nr=(size(a))(2)
	print, format='(a12," : image size(pts)=",i3," x ",i3,". pixels(um)= ",f5.3," x ",f5.3)', $
	    fileshort,nc,nr,xincr,yincr
	xaxis=findgen(nc)*xincr+xoff
	yaxis=findgen(nr)*yincr+yoff

;data=a(0:(nc-1),2:(nr+1))	;earlier files had two line header
;  need to make option for earlier files

	b0 =where(b eq 0, count)
	if count ne 0 then b(b0) = median(b)
	d = a/b
	fileshort=strmid(fileshort,0,strlen(fileshort)-4)
	if keyword_set(deglitch) then BEGIN
		a = dd
		plot,a, xstyle=1, color=255, background=0
		cursor, x1, y1, /data, /down
		cursor, x2, y2, /data, /down
		zl=where(a LT y1)
		zh=where(a GT y2)
		zl=zl>1
		zh=zh>1
		a(zl)=(a(zl-1)+a(zl+1))*0.5
		a(zh)=(a(zh-1)+a(zh+1))*0.5
		d=a
	ENDIF
type = '2d'
if sd.wavelength EQ 0. then sd.wavelength = 12398.        ; PROTECTION !!
xl = 'x (um)      E(eV)= ' + strcompress(string(12398./sd.wavelength)) $
     + '    dwell(ms) =  ' + strcompress(string(sd.dwell_time))
s={t:type, d:d, x:xaxis, y:yaxis, xl:xl, yl:'y (um)  [gli]', dl:fileshort+'_img/nrm'}

	if keyword_set(pl) then splot2d, s, _extra=e, charsize=1

endif else begin 	; go here if user pushes 'cancel'
    print, ' file name of zero length. Read aborted'
    s=0
endelse

return, s
end