; Copyright (c) 1998-2011 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		READ_ALS
;
;LAST CHANGED: ----------------------------------- 	03-Feb-11
;
; PURPOSE:
;	This function reads a Beamline 7 STXM image from a text file (*,im*, *,nrm)
; the image size, energy, dwell information is read from (*,dat)
; NB different formats were used for (*.dat) at various times
;
; CATEGORY:
;	Image display.
;
; CALLING SEQUENCE:
;	Result = READ_ALS, FILE,  PLOT=pl, DEGLITCH=dgl, FILTER=fltr, _extra=e
;
; INPUTS:
; 	FILE		name of ALS BL 7 image file
;
; KEYWORDS:
;	PLOT		plot
;	DEGLITCH	remove glitch points
;	FILTER		extension
;
; OUTPUTS: axis standard file
;
; COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;
;
; MODIFICATION HISTORY:
; (27-may-97 aph) adapted from READ_IMG.PRO (Stefano code  of Jan97)
; ( 7-Aug-97 aph) separate file  (aph 9-oct-97 control color locally)
; ( 9-dec-97 aph) (16-feb-98) - cosmetics
; ( 3-mar-98 aph) non-square data; read in photon energy, dwell - store in SD
; ( 6-jun-98 aph) add identifier to y label indicating ALS source
; (14-jun-98 aph) axis_com
; (28-jul-98 aph) dwell format
; (07-Aug-98 aph) extension in label
; ( 7-jul-99 aph) FREE_LUN as well as close !
; (26-mar-00 aph) extend energy format for > 1 keV
; (26-sep-00 aph) add E to 2d structure
; (15-nov-00 cgz) Replaced call of NCOLS function by explicit (SIZE(var))(1)
; (15-nov-00 cgz) Replaced call of NROWS function by explicit (SIZE(var))(2)
; (03-Feb-11 aph) AXIS standard header added
;-

function read_als, file, PLOT=pl, DEGLITCH=dgl, FILTER=fltr, _extra=e

@axis_com
on_error,2

if n_elements(file) eq 0 then begin  ;popup file dialog box
   if not keyword_set(fltr) then fltr='*.im*'
   file=PICKFILE2(/Read, FILTER=fltr, /LPATH, DEFPATH=defpath)
endif

if strlen(file) GT 0 THEN BEGIN
	name_bits = ax_name(file)	; sort the name into its parts
	path = name_bits(0)
	fileshort = name_bits(1)
    ext = name_bits(2)
    file = path + fileshort

; (aph 2-mar-98 - converted to Jacobsen's readin as it does not assume SQUARE input data !)
; puts energy and dwell parameters into the nsls SCANDATA (SD) structure
openr,lun,(file+'.dat'), /get_lun
x_start = float(0)    &   x_step = float(0)
y_start = float(0)    &   y_step = float(0)
n_cols = fix(0)       &   n_rows = fix(0)
input_string = ''
readf,lun,input_string
reads,input_string,x_start,x_step,n_cols
;print, '1:  ', input_string
xoff = 1.e3*x_start  & xincr = 1.e3*x_step
readf,lun,input_string
reads,input_string,y_start,y_step,n_rows
;print, '2:  ', input_string
yoff = 1.e3*y_start  & yincr = 1.e3*y_step
readf,lun,input_string
;print, '3:  ', input_string
on_ioerror, continue
energy = 0.
reads,input_string,delay,delay,dwell,energy
continue:                ; when reading pre-Mar-98 files without photon energy
on_ioerror,null
sd.dwell_time = dwell/1000.    ; report dwell in msec
close,lun & free_lun,lun
if (energy NE 0)then sd.wavelength=12398./energy    ; save photon energy as wavelength

;Do not allow zero increment. If so set to 1.
	xincr=xincr + (xincr eq 0.)
	yincr=yincr + (yincr eq 0.)

	a=text_read1(file+'.' + ext)
	;nc=ncols(a)
	nc=(size(a))(1)
	;nr=nrows(a)
	nr=(size(a))(2)
	print, format='("Read ALS STXM file:",a20,".  ",i4," x ",i4," points. ",f7.3," x ",f7.3, " um pixels. E = ",f8.3," eV.  Dwell = ",f7.2," ms")', $
	    fileshort, nc, nr, xincr, yincr, energy, sd.dwell_time
	xaxis=findgen(nc)*xincr+xoff
	yaxis=findgen(nr)*yincr+yoff

;data=a(0:(nc-1),2:(nr+1))	;earlier files had two line header
;  need to make option for earlier files

	d=a
	if keyword_set(deglitch) then BEGIN	; FORCE DEGLITCH !!
		plot,a, xstyle=1, color=255, background=0
		cursor, x1, y1, /data, /down
		cursor, x2, y2, /data, /down
		zl=where(a LT y1)
		zh=where(a GT y2)
		zl=zl>1
		zh=zh>1
		a(zl)=(a(zl-1)+a(zl+1))*0.5
		a(zh)=(a(zh-1)+a(zh+1))*0.5
		d=a
	ENDIF
type = '2d'
if sd.wavelength EQ 0. then sd.wavelength = 12398.
energy = 12398./sd.wavelength
xl = string(FORMAT='("x (um)     E = ",f8.3," eV     dwell = ",f5.2," ms")', $
      energy, sd.dwell_time)
s={t:type, d:d, x:xaxis, y:yaxis, e: energy, xl:xl, yl:'als ('+ext+')   y (um)', dl:fileshort}

if keyword_set(pl) then splot2d, s, _extra=e, charsize=1

endif else begin 	; go here if user pushes 'cancel'
    print, ' file name of zero length. Read aborted'
    s=0
endelse

return, s
end