; Copyright (c) 1998-2008 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		READ_BESSY_XML.PRO
;
;LAST CHANGED: ----------------------------------- 	11-Oct-08
;
; PURPOSE:
;	This function reads a text file witten in XML syntax
; which provides  undulator, beamline, microscope and image parameters for Bessy STXM
;
; CATEGORY:
;	data read routine. can execute outside of aXis2000
;
; CALLING SEQUENCE:
;	Result = READ_BESSY_XML(file=file, filter=filter, verbose=verbose)
;
; INPUTS:
;
; KEYWORDS:
;	FILE:  name of file (*.pgm)
;	FILTER: extension (default is '*.xml')
;	VERBOSE:  if on, print parameters
;
; OUTPUTS:
;	retuns an IDL named structure
;
; COMMON BLOCKS: none
;
; SIDE EFFECTS: none
;
; RESTRICTIONS: none
;
; PROCEDURE:
;adapted from crate_nc.pro supplied
;
;
; MODIFICATION HISTORY:
; (11-Oct-08 aph) first version; derived from read_xml.pro by Jurgen Thieme
;-

function read_bessy_xml, file=file, filter=filter, verbose=verbose
on_error,2

if n_elements(file) eq 0 then begin  ;popup file dialog box
   if not keyword_set(filter) then filter='*.xml'
   file=PICKFILE2(/Read, FILTER=filter, /LPATH, DEFPATH=defpath)
endif

if keyword_set(verbose) then print, 'reading ', file

openr, inunit, file, /get_lun

vec=fltarr(19)

a=''
b1=''
b2=''
c1=''
c2=''
d1=''
d2=''
command_line=''
dwell_time_i=''
dwell_time_f=''
n_x_i=''
n_x_f=''
n_y_i=''
n_y_f=''
digital_step_x=''
digital_step_y=''
width_i=''
width_f=''
height_i=''
height_f=''
e1=''
x_center=''
y_center=''
e2=''
g1=''
g2=''
left=''
right=''
bottom=''
top=''
g3=''
i1=''
i2=''
step_x=''
step_y=''
i3=''
k1=''
k2=''
f1=''
h1=''
min1=''
max1=''
n1=''
h2=''
j1=''
min2=''
max2=''
n2=''
j2=''
f2=''
exposure_time=''
k3=''
l1=''
l2=''
zp=''
osa=''
sample=''
l3=''
m1=''
m2=''
o1=''
o2=''
year=''
month=''
day=''
hour=''
minute=''
second=''
o3=''
p1=''
p2=''
undulator_gap=''
undulator_gap_energy=''
begin_beam_current=''
p3=''
r1=''
r2=''
;beta=''
;gamma=''
r3=''
d3=''


readf, inunit, a
readf, inunit, b1, b2
readf, inunit, c1, c2
readf, inunit, d1, d2
readf, inunit, command_line
readf, inunit, dwell_time_i, dwell_time_f
readf, inunit, n_x_i, n_x_f
readf, inunit, n_y_i, n_y_f
readf, inunit, digital_step_x
readf, inunit, digital_step_y
readf, inunit, width_i, width_f
readf, inunit, height_i, height_f
readf, inunit, e1, x_center, y_center, e2
readf, inunit, g1, g2,left, right, bottom, top, g3
readf, inunit, i1, i2, step_x, step_y, i3
readf, inunit, k1, k2, f1, h1, min1, max1, n1, h2, j1, min2, max2, n2, j2, f2, exposure_time, k3
readf, inunit, l1,l2, zp, osa, sample, l3
readf, inunit, m1, m2
readf, inunit, o1, o2, year, month, day, hour, minute, second, o3
readf, inunit, p1, p2, undulator_gap, undulator_gap_energy, begin_beam_current, p3
readf, inunit, r1, r2, r3
readf, inunit, d3
close, inunit
free_lun, inunit



;print, a
;print, b1, b2
;print, c1, c2
;print, d1, d2
;print, command_line
;print, dwell_time_i, dwell_time_f
;print, n_x_i, n_x_f
;print, n_y_i, n_y_f
;print, digital_step_x
;print, digital_step_y
;print, width_i, width_f
;print, height_i, height_f
;print, e1
;print, x_center
;print, y_center
;print, e2
;print, g1, g2
;print, left
;print, right
;print, bottom
;print, top
;print, g3
;print, i1, i2
;print, step_x
;print, step_y
;print, i3
;print, k1, k2
;print, f1
;print, h1
;print, min1
;print, max1
;print, n1
;print, h2
;print, j1
;print, min2
;print, max2
;print, n2
;print, j2
;print, f2
;print, exposure_time
;print, k3
;print, l1, l2
;print, zp
;print, osa
;print, sample
;print, l3
;print, m1, m2
;print, o1, o2
;print, year
;print, month
;print, day
;print, hour
;print, minute
;print, second
;print, o3
;print, p1, p2
;print, undulator_gap
;print, undulator_gap_energy
;print, begin_beam_current
;print, p3
;print, r1, r2
;print, beta
;print, gamma
;print, r3
;print, d3


var1=strsplit(x_center, '</x>', /extract, /regex)
x_center_string=strsplit(var1, '<x>', /extract, /regex)

var2=strsplit(y_center, '</y>', /extract, /regex)
y_center_string=strsplit(var2, '<y>', /extract, /regex)

var3=strsplit(left, '</left>', /extract, /regex)
x_start_string=strsplit(var3, '<left>', /extract, /regex)

var4=strsplit(right, '</right>', /extract, /regex)
x_stop_string=strsplit(var4, '<right>', /extract, /regex)

var5=strsplit(bottom, '</bottom>', /extract, /regex)
y_start_string=strsplit(var5, '<bottom>', /extract, /regex)

var6=strsplit(top, '</top>', /extract, /regex)
y_stop_string=strsplit(var6, '<top>', /extract, /regex)


var7=strsplit(exposure_time, '</exposure-time>', /extract, /regex)
time_string=strsplit(var7, '<exposure-time>', /extract, /regex)

var8=strsplit(zp, '</zp>', /extract, /regex)
focus_position_string=strsplit(var8, '<zp>', /extract, /regex)

var9=strsplit(undulator_gap,'</undulator-gap>', /extract, /regex)
undulator_gap_string=strsplit(var9, '<undulator-gap>', /extract, /regex)

var10=strsplit(undulator_gap_energy, '</undulator-gap-energy>', /extract, /regex)
energy_string=strsplit(var10, '<undulator-gap-energy>', /extract, /regex)

var11=strsplit(hour, '</hour>', /extract, /regex)
hour_string=strsplit(var11, '<hour>', /extract, /regex)

var12=strsplit(minute, '</minute>', /extract, /regex)
minute_string=strsplit(var12, '<minute>', /extract, /regex)

var13=strsplit(second, '</second>', /extract, /regex)
second_string=strsplit(var13, '<second>', /extract, /regex)

var14=strsplit(day, '</day>', /extract, /regex)
day_string=strsplit(var14, '<day>', /extract, /regex)

var15=strsplit(month, '</month>', /extract, /regex)
month_string=strsplit(var15, '<month>', /extract, /regex)

;var16=strsplit(beta, '</beta>', /extract, /regex)
;beta_string=strsplit(var16, '<beta>', /extract, /regex)

;var17=strsplit(gamma, '</gamma>', /extract, /regex)
;gamma_string=strsplit(var17, '<gamma>', /extract, /regex)


var18=strsplit(begin_beam_current, '</begin-beam-current>', /extract, /regex)
ring_current_string=strsplit(var18, '<begin-beam-current>', /extract, /regex)
reads, ring_current_string, ring_current

;print, x_center_string
;print, y_center_string
;print, x_start_string, x_stop_string, y_start_string, y_stop_string
;print, time_string
;print, focus_position_string
;print, undulator_gap_string
;print, energy_string


reads, x_center_string, x_0
reads, y_center_string, y_0
reads, x_start_string, x_start
reads, x_stop_string, x_stop
reads, y_start_string, y_start
reads, y_stop_string, y_stop
reads, time_string, time
reads, focus_position_string, focus_position
reads, undulator_gap_string, gap
reads, energy_string, energy

; ----- ingored date, time as non-functional 10-oct-08
;reads, hour_string, hour
;reads, minute_string, minute
;reads, second_string, second
;;reads, hour_string, hour_0
;;reads, minute_string, minute_0
;;reads, second_string, second_0
;;reads, day_string, day_0
;;reads, month_string, month_0
;reads, beta_string, beta_0
;reads, gamma_string, gamma_0
;;hour=fix(hour_0)
;;minute=fix(minute_0)
;;second=fix(second_0)
;day=fix(day_0)
;;month1=fix(month_0)
;beta=beta_0
;gamma=gamma_0

dwell_time=time*1000
x_center=x_0
y_center=y_0
undulator_gap=gap
wavelength=12398.52/energy
initial_lambda=12398.52/energy
final_lambda=12398.52/energy

; ------ method Bessy code used to return variables
vec(0)=x_center
vec(1)=y_center
vec(2)=x_start
vec(3)=x_stop
vec(4)=y_start
vec(5)=y_stop
vec(6)=dwell_time
vec(7)=focus_position
vec(8)=undulator_gap
vec(9)=wavelength
vec(10)=initial_lambda
vec(11)=final_lambda
; - not functional
;vec(12)=hour
;vec(13)=minute
;vec(14)=second
;vec(15)=day
;;vec(16)=month1
;vec(17)=beta
;vec(18)=gamma

; return, vec

; -------- named structure to return variables
imagepar = {ring_current: ring_current, energy: energy, dwell: dwell_time, $
            x_center: x_center, y_center: y_center, $
            x_start: x_start, x_stop: x_stop, y_start: y_start, y_stop: y_stop }
if keyword_set(verbose) then help, imagepar, /struct

return, imagepar
end
