; Copyright (c) 1998-2015 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		SDF_STACK_CUR
;
;LAST CHANGED: ----------------------------------- 02-jul-15
;
; PURPOSE:
;	This function reads self-defining format ascii files written by "ALS 532"-class instruments
; using STXM_Control as their operating system (as of 30-Jul-09: ALS (3), CLS, SLS, Bessy, Stanford)
; Spectra, images, stacks and linescans have *.hdr and a set of *.xim files
; Images and stacks with non-square pixels are extended to have square pixels
; Image modes have separate file for each {energies.channels.regions}
; Spectra are a *#.xsp file for each region (#) containing multi-column spectra.
; Images, stacks are normalized to 400 mA ring current (N400)
;
; CATEGORY:
;	Input / output utilty; stand alone or from ax_sdf / axis2000
;
; CALLING SEQUENCE:
;	Result = sdf_stack_cur(index)
;
; INPUTS: none required
;
; KEYWORDS:
; 	INDEX		number of the image whose current will be read
;	_EXTRA		other passed through parameters
;
; OUTPUTS:
;	structure variable; either 1d (spectra) or 2d (image, linescan) or 3d (stack, as *.ncb)
;
; COMMON BLOCKS:
;	STACK_PROCESS_COM	common for stack_process
;	AXIS_COM	standard set of common blocks
;	BSIF_COM	stack common
;	SDF_COM		common for SDF read in
;
; MODIFICATION HISTORY:
; (02-Jul-15 aph) extracted from read_sdf as need to compile before/during ax_sdf


Function sdf_stack_cur, index, _extra=_extra
; --------------- read current from file (sdf_lastfile)  ---------------
@stack_process_com
@axis_com
@bsif_com
@sdf_com

on_error,2

; ------ check if sdf_lastfile is a combined path_fname_extension - if so, split (KLUGE, 19-Dec-13, updated 16-Jun-14)
if n_elements(sdf_lastfile) NE 0 then begin
	if strpos(sdf_lastfile,path_sep()) NE -1 then begin
		print, 'SDF_lastfile is actually a path & filename. Separating them.', sdf_lastfile
		t = ax_name(sdf_lastfile)
		sdf_path = t(0)
	  	sdf_lastfile = t(1)
	endif
endif

file = sdf_path + sdf_lastfile + '.hdr'   ;changed  BACK  18-Dec-13
get_lun,lun
openr,lun, file
Iring = 1.
line= ' '
; this works for OLD format image1 .. image10 etc  - NOTE - numbering starts at 1, not 0
; but not for the new format   image000_0 image000_1  (xmcd)  etc
str_tst='Image' + strtrim(string(fix(index+1)),2)
while not  eof(lun) do begin
	readf, lun, line
	test = strpos(line, str_tst)
	if test NE -1 then goto, get_current  ; - found a valid line with current
endwhile
close, lun & free_lun, lun

; second_check - execute this is the first approach does not work
; files after November 2010 have this format
get_lun,lun
openr,lun, file
Iring = 1.
line= ' '
; new format   image000_0 image000_1  (xmcd)  etc  - NOTE for new scheme , numbering starts at 0
index2 = 1000 + index
str_tst='Image' + strmid(strtrim(string(index2),2),1)
while not  eof(lun) do begin
	readf, lun, line
	test = strpos(line, str_tst)
	if test NE -1 then goto, get_current  ; - found a valid new format line with current
endwhile
close, lun & free_lun, lun

; OK cannot find a line at bottom of the header file with the ring current in it so give up
return, Iring

; Now we have a valid line so extract the current
get_current:
close, lun & free_lun, lun
test1= strpos(line, 'StorageRingCurrent ')
test1= strpos(line, '= ', test1)
test2= strpos(line, ';', test1)
Iring = float(strmid(line, test1+2, test2-test1))
return, Iring
END
