; Copyright (c) 1995-2014 JDD, A.P. Hitchcock  All rights reserved
;+
;NAME:
;		STAG.PRO
;
;LAST CHANGED: ----------------------------------- 	21 Jul 2014
;
; PURPOSE:
;	This function checks for  existence of one or more specified structure field (or tag)
; returns T/F (0/1) byte or byte array
;
; CATEGORY:
;	data utility
;
; CALLING SEQUENCE:
; for procedures:
;	ZOOM [, FACT = Fact, /INTERP, XSIZE = Xs, YSIZE = Ys, /CONTINUOUS, $
;		/KEEP, ZOOM_WINDOW=Zoom_Win, /NEW_WINDOW ]
; for functions:
;	Result = STAG (s, tag(s))
;
; INPUTS:
;	S 	structure
;	TAG	array of tags to check for
;
; KEYWORDS:
;	KEY1:
;
; OUTPUTS:
;	No explicit outputs.   A new window is created if necessary
;;
; MODIFICATION HISTORY:
; (11-nov-00 cgz) migrated from STRUCTURE.PRO
; (21-Jul-14 aph) AXIS standard header added
;-

function STAG, s, tags
on_error,2

ss=size(s)
if ss(0)*ss(2) ne 8 then message, 'input not a structure'

fields=strlowcase( tag_names(s) )
fstr=''
for i=0, n_tags(s)-1 do fstr=fstr+fields(i)+';'
;print, fstr

tags=strlowcase(tags)
nt=n_elements(tags)
exist=bytarr(nt)
for i=0, nt-1 do exist(i)=strpos( fstr, tags(i) ) gt -1
;print, exist
;exist= fix( (exist+.1)/abs(exist+.1) )>0
if nt eq 1 then return, exist(0) $
else return, exist
end

