; Copyright (c) 1998-2010 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	THUMBPLOT
;
;LAST CHANGED: ----------------------------------- 19-dec-00
;
;PURPOSE:
;	Thumbplot plots a thumbnail of buffer data in Bufnum
;
;CATEGORY:
;	AXIS:  utility (captive)
;
;CALLING SEQUENCE:
;	ThumbPlot, BUFNUM
;
;CALLED FROM AXIS:
;	whenever execute PlotBuf to display a new Buffer; clear; etc
;
 ;INPUTS:
;	BUFNUM  - number of buffer to update thumbnail
;
;KEYWORDS: none
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;MODIFICATION HISTORY:
; (   MAR-98 APH) split from axis_c to shrink file
; (14-jun-98 aph) axis_com
; (24-jun-99 aph) consistent color for image/spectra ; ADD zstack_color_common
; (26-jul-99 aph) if curBuf=0, only update labels
; (26-sep-99 aph) separated from THUMBS.PRO to have file name = run name
;                adapted to 9 separate windows
; (31-jan-00 aph) AXIS standard documentation; re-ordered to avoid loss of utility routines
; (11-mar-00 aph) remove comment on @axis_com line
; (16-apr-00 aph) handle 3d images which have 3-channel (3-d) data structure
; (19-dec-00 cgz) substituted ax_white_color_index with ax_plot_axes_color_index
;			substituted ax_black_color_index with ax_plot_bkgd_color_index
; (16-Feb-10 aph) separated  from parent thumblbls.pro to follow IDL conventions
;-



PRO ThumbPlot,BufNum

@axis_com
on_error,2

if BufNum LT 1 OR BufNum GT 9 then return

WSET, Thumbnail(BufNum)          ; shift to Thumbnail draw window
bgndcol = ax_plot_axes_color_index	;ax_white_color_index             ; WHITE background

HANDLE_VALUE, Data(BufNum), tmp
IF n_tags(tmp) NE 0 THEN BEGIN  ; only process if there is data !!
	!X.S = Xscl(BufNum,*)   	; restore image (x,y,z) scaling parameters
	!Y.S = Yscl(BufNum,*)
	!Z.S = Zscl(BufNum,*)
	siz = 51
	CASE tmp.t OF
	'3d' : begin
;		tvlct, tmp.r, tmp.g, tmp.b, ax_low_color_index
		ts = size(tmp.d)
 		if ts(0) EQ 3 then begin
 			image = color_quan(tmp.d,1,R,G,B)
 			tmp = {t:'2d', x:tmp.x, y:tmp.y, d: image, xl:tmp.xl, yl:tmp.yl, dl:tmp.dl}
		endif
		tmp.t = '2d'  ; kluge to get make_square to work !
		make_square,tmp
		b = congrid(ax_imscl(tmp.d),siz,siz, /INTERP)
		tv,b
;		tvlct, userR, userG, userB
	  end
	'2d' : begin
		make_square,tmp
		b = congrid(ax_imscl(tmp.d),siz,siz, /INTERP)
		tv,b
	  end
	'1d' : begin
		ColTmp = bcolor(BufNum)
		erase, ax_plot_axes_color_index 	;ax_white_color_index
		; check for non-monotonic and split into sections if so
		del = tmp.x(1:*) - tmp.x(0:*)
		sect = where(del LT 0,n_plot)
		if n_plot GT 0 then begin
			longsect = 0  & length = tmp.x(sect(0)) - tmp.x(0)
			for i = 0, n_plot-2 do begin  ; find largest x-range portion; plot that only
			  if tmp.x(sect(i+1)) - tmp.x(sect(i)+1) GT length then begin
			  		longsect = i+1  & length = tmp.x(sect(i+1)) - tmp.x(sect(i)+1)
			  endif
			endfor
			nbegin = 0
			if (longsect GE 1) then nbegin = sect(longsect-1) + 1
			t = size(tmp.x) & nend = t(2)
			if (longsect LT n_plot) then nend = sect(longsect)
;				print, 'nbegin,nend, n_plot, longsect, color',  nbegin, nend, n_plot, longsect, ColTmp
   			xydat = convert_coord(tmp.x(nbegin:nend), tmp.d(nbegin:nend), /to_device)
;				print, 'buffer # ', BufNum, '   multi-section. plotting longest section'
			plot,xydat(0,*), xydat(1,*),/device, background= bgndcol, $
		  	   xstyle=5, ystyle=5, psym=0, color=ColTmp, thick=2, /noerase, $
		  	   xmargin=[0,0],ymargin=[0,0]
            for i = 0, n_plot-2 do begin
    			xax=tmp.x(sect(i)+1:sect(i+1))
    			dat = tmp.d(sect(i)+1:sect(i+1))
            	xydat = convert_coord(xax,dat, /to_device)
		        	oplot,xydat(0,*), xydat(1,*), color=ColTmp
			endfor
			xax=tmp.x(sect(n_plot-1)+1:*)
			dat = tmp.d(sect(n_plot-1)+1:*)
			xydat = convert_coord(xax,dat, /to_device)
            oplot,xydat(0,*), xydat(1,*), color=ColTmp
; **
		endif else begin
	    	xydat = convert_coord(tmp.x, tmp.d, /to_device)
			plot,xydat(0,*), xydat(1,*),/device, background= bgndcol, $
		  	   xstyle=5, ystyle=5, psym=0, color=ColTmp, thick=2, /noerase, $
		  	   xmargin=[0,0],ymargin=[0,0]
		endelse
 	  end
   ENDCASE
endif else erase, ax_plot_bkgd_color_index		;ax_black_color_index      ; erase thumblabel if no data
END
