/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.javab;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ReflQuery {
    public static void printConstructors(Class clazz) {
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            Constructor<?> constructor = constructorArray[i];
            Class<?>[] classArray = constructor.getParameterTypes();
            String string = constructor.getName();
            System.out.print(Modifier.toString(constructor.getModifiers()));
            System.out.print(" " + string + "(");
            for (int j = 0; j < classArray.length; ++j) {
                if (j > 0) {
                    System.out.print(", ");
                }
                System.out.print(classArray[j].toString());
            }
            System.out.println(");");
        }
    }

    public static void printMethods(Class clazz) {
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            Class<?> clazz2 = method.getReturnType();
            Class<?>[] classArray = method.getParameterTypes();
            String string = method.getName();
            System.out.print(Modifier.toString(method.getModifiers()));
            System.out.print(" " + clazz2.getName() + " " + string + "(");
            for (int j = 0; j < classArray.length; ++j) {
                if (j > 0) {
                    System.out.print(", ");
                }
                System.out.print(classArray[j].getName());
            }
            System.out.println(");");
        }
    }

    public static void printFields(Class clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            Class<?> clazz2 = field.getType();
            String string = field.getName();
            System.out.print(Modifier.toString(field.getModifiers()));
            System.out.println(" " + clazz2.getName() + " " + string + ";");
        }
    }

    public static void printSuperclasses(Object object) {
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = clazz.getSuperclass();
        while (clazz2 != null) {
            String string = clazz2.getName();
            System.out.println(string);
            clazz = clazz2;
            clazz2 = clazz.getSuperclass();
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("  Usage: java com.rsi.javab.ReflectionUtil <classname>");
            return;
        }
        String string = stringArray[0];
        try {
            Class<?> clazz = Class.forName(string);
            Class<?> clazz2 = clazz.getSuperclass();
            System.out.println("Class " + string);
            System.out.println("------ Ctors:");
            ReflQuery.printConstructors(clazz);
            System.out.println("------ Methods:");
            ReflQuery.printMethods(clazz);
            System.out.println("------ Fields:");
            ReflQuery.printFields(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Class not found.");
        }
    }
}

