/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.javab;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ReflQuery {
    public static void printConstructors(Class clazz) {
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        int n = 0;
        while (n < constructorArray.length) {
            Constructor<?> constructor = constructorArray[n];
            Class<?>[] classArray = constructor.getParameterTypes();
            String string = constructor.getName();
            System.out.print(Modifier.toString(constructor.getModifiers()));
            System.out.print(" " + string + "(");
            int n2 = 0;
            while (n2 < classArray.length) {
                if (n2 > 0) {
                    System.out.print(", ");
                }
                System.out.print(classArray[n2].toString());
                ++n2;
            }
            System.out.println(");");
            ++n;
        }
    }

    public static void printMethods(Class clazz) {
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            Class<?> clazz2 = method.getReturnType();
            Class<?>[] classArray = method.getParameterTypes();
            String string = method.getName();
            System.out.print(Modifier.toString(method.getModifiers()));
            System.out.print(" " + clazz2.getName() + " " + string + "(");
            int n2 = 0;
            while (n2 < classArray.length) {
                if (n2 > 0) {
                    System.out.print(", ");
                }
                System.out.print(classArray[n2].getName());
                ++n2;
            }
            System.out.println(");");
            ++n;
        }
    }

    public static void printFields(Class clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = 0;
        while (n < fieldArray.length) {
            Field field = fieldArray[n];
            Class<?> clazz2 = field.getType();
            String string = field.getName();
            System.out.print(Modifier.toString(field.getModifiers()));
            System.out.println(" " + clazz2.getName() + " " + string + ";");
            ++n;
        }
    }

    public static void printSuperclasses(Object object) {
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = clazz.getSuperclass();
        while (clazz2 != null) {
            String string = clazz2.getName();
            System.out.println(string);
            clazz = clazz2;
            clazz2 = clazz.getSuperclass();
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("  Usage: java com.rsi.javab.ReflectionUtil <classname>");
            return;
        }
        String string = stringArray[0];
        try {
            Class<?> clazz = Class.forName(string);
            Class<?> clazz2 = clazz.getSuperclass();
            System.out.println("Class " + string);
            System.out.println("------ Ctors:");
            ReflQuery.printConstructors(clazz);
            System.out.println("------ Methods:");
            ReflQuery.printMethods(clazz);
            System.out.println("------ Fields:");
            ReflQuery.printFields(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Class not found.");
        }
    }
}

