/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class FrameTestImageArea
extends RSIImageArea
implements MouseMotionListener,
MouseListener {
    int m_boxw = 100;
    int m_boxh = 100;
    Dimension c_dim;
    boolean m_pressed = false;
    int m_button = 0;
    Vector c_resizelisteners = null;

    public FrameTestImageArea(String string, Dimension dimension) {
        super(string, dimension);
        this.c_dim = dimension;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public void addResizeListener(FrameTestImageAreaResizeListener frameTestImageAreaResizeListener) {
        if (this.c_resizelisteners == null) {
            this.c_resizelisteners = new Vector();
        }
        if (!this.c_resizelisteners.contains(frameTestImageAreaResizeListener)) {
            this.c_resizelisteners.add(frameTestImageAreaResizeListener);
        }
    }

    public void removeResizeListener(FrameTestImageAreaResizeListener frameTestImageAreaResizeListener) {
        if (this.c_resizelisteners == null) {
            return;
        }
        if (this.c_resizelisteners.contains(frameTestImageAreaResizeListener)) {
            this.c_resizelisteners.remove(frameTestImageAreaResizeListener);
        }
    }

    public void displayImage() {
        Graphics graphics = this.getGraphics();
        this.update(graphics);
    }

    public void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n != -1 && n2 != -1 && (n != this.c_dim.width || n2 != this.c_dim.height)) {
            this.c_dim.width = n;
            this.c_dim.height = n2;
            this.setPreferredSize(this.c_dim);
            this.setSize(this.c_dim);
            if (this.c_resizelisteners != null) {
                FrameTestImageAreaResizeListener frameTestImageAreaResizeListener = null;
                for (int i = 0; i < this.c_resizelisteners.size(); ++i) {
                    frameTestImageAreaResizeListener = (FrameTestImageAreaResizeListener)this.c_resizelisteners.elementAt(i);
                    frameTestImageAreaResizeListener.areaResized(n, n2);
                }
            }
        }
        super.paint(graphics);
    }

    public void setImageFile(String string) {
        super.loadImage(string);
        this.displayImage();
    }

    public void drawZoomBox(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX() - this.m_boxw / 2;
        n2 = n2 >= 0 ? n2 : 0;
        int n3 = mouseEvent.getY() - this.m_boxh / 2;
        n3 = n3 >= 0 ? n3 : 0;
        int n4 = n2 + this.m_boxw;
        if (n4 > this.c_dim.width) {
            n4 = this.c_dim.width;
            n2 = this.c_dim.width - this.m_boxw;
        }
        if ((n = n3 + this.m_boxh) > this.c_dim.height) {
            n = this.c_dim.height;
            n3 = this.c_dim.height - this.m_boxh;
        }
        this.displayImage();
        Graphics graphics = this.getGraphics();
        graphics.drawImage(this.m_img, n2, n3, n4, n, n2 + this.m_boxw / 4, n3 + this.m_boxh / 4, n4 - this.m_boxw / 4, n - this.m_boxh / 4, null);
        graphics.setColor(Color.white);
        graphics.drawRect(n2, n3, this.m_boxw, this.m_boxh);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.drawZoomBox(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Graphics graphics = this.getGraphics();
        if (this.m_pressed && this.m_button == 1) {
            this.drawZoomBox(mouseEvent);
            graphics.setColor(Color.white);
            graphics.drawString("DRAG", 10, 10);
        } else {
            graphics.setColor(Color.white);
            String string = "(" + mouseEvent.getX() + "," + mouseEvent.getY() + ")";
            this.displayImage();
            graphics.drawString(string, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.m_pressed = true;
        this.m_button = mouseEvent.getButton();
        if (this.m_button == 1) {
            this.drawZoomBox(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.m_pressed = false;
        this.m_button = 0;
    }
}

